#include "FileManager.h"
#include <iostream>
#include <fstream>
#include <iomanip>
#include <deque>

void printMainMenu() {
        std::cout << " Menu:" << std::endl << std::endl
                << "1) Make file using a file stream" << std::endl
                << "2) Make file with stream iterators" << std::endl
                << "3) Load data in container with a file stream" << std::endl
                << "4) Load data in container with a stream iterator" << std::endl
                << "5) Modify data using template function" << std::endl
                << "6) Modify data using container iterators" << std::endl
                << "7) Modify data using transform algorithm" << std::endl
                << "8) Output data with a file stream" << std::endl
                << "9) Output data using copy algorithm and stream iterators" <<std::endl
                << "x) Exit" << std::endl << std::endl
                << "Input here:   " << std::endl;
}

int main() {
        std::string fileName = "numbers.txt";
        std::string resFile = "res.txt";
	std::deque<int> cont;
        FileManager file_manager;

	char input = 'q';
        while (input != 'x') {
		printMainMenu();
		std::cin >> input;
		std::cout << std::endl << std::endl;
                std::ofstream of_stream;
                std::ifstream if_stream;

		switch (input){
		case'1':
                        of_stream.open(fileName);
			try {
                                file_manager.createData(of_stream);
			}
			catch (std::runtime_error err) {
				std::cout << err.what() << std::endl;
			}
                        std::cout << "File created succesfully" << std::endl;
                        of_stream.close();
			break;

		case'2':
                        of_stream.open(fileName);
                        file_manager.createData(std::ostream_iterator<int>(of_stream, " "));
                        std::cout << "File created succesfully" << std::endl;
                        of_stream.close();
			break;

		case'3':
                        if_stream.open(fileName);
			try {
                                file_manager.loadData(cont, if_stream);
			}
			catch (std::runtime_error err) {
				std::cout << err.what() << std::endl;
			}
			
                        std::cout << "Data is loaded in container" << std::endl;
                        if_stream.close();
			break;
			
		case'4':
                        if_stream.open(fileName);
                        if (!if_stream.is_open()) {
                                std::cout << "File isn't opened" << std::endl;
				break;
			}
                        file_manager.loadData(cont, std::istream_iterator<int>(if_stream), std::istream_iterator<int>());
                        std::cout << "Data is loaded in container" << std::endl;
                        if_stream.close();
			break;

		case'5':
			try {
                                file_manager.modify(cont);
			}
			catch (std::exception ex) {
				std::cout << ex.what() << std::endl;
			}
			break;

		case'6':
			try {
                                file_manager.modify(cont.begin(), cont.end());
			}
			catch (std::exception ex) {
				std::cout << ex.what() << std::endl;
			}
			break;

		case'7':
                        if_stream.open(fileName);
                        of_stream.open(resFile);
                        if (!if_stream.is_open() && !of_stream.is_open()) {
                                std::cout << "File isn't opened" << std::endl;
				break;
			}
                        file_manager.modify(std::istream_iterator<int>(if_stream), std::istream_iterator<int>(), std::ostream_iterator<int>(of_stream, " "));
                        if_stream.close();
                        of_stream.close();


		case'8':
                        of_stream.open(resFile);
			try {
                                file_manager.out_res(cont, of_stream);
			}
			catch(std::exception ex){
				std::cout << ex.what() << std::endl;
			}
                        of_stream.close();

		case'9':
                        of_stream.open(resFile);
			try {
                                file_manager.out_res(cont, std::ostream_iterator<int>(of_stream," "));
			}
			catch(std::exception ex){
				std::cout << ex.what() << std::endl;
			}
                        of_stream.close();
		case'x':
			break;

		default:
                        std::cout << "This input is not valid" << std::endl;
		}
	}
	
	return 0;
}
